'use strict'

entityRegistry['system']['transport'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
        { paramName: 'beatsPerBar', displayName: 'Beats per bar', type: 'int', defaultValue: 4, triggerInit: false },
        { paramName: 'modules', displayName: 'Modules', type: 'entityArray', defaultValue: [], triggerInit: false },
        { paramName: 'markers', displayName: 'Markers', type: 'floatArray', defaultValue: [], triggerInit: false },
        { paramName: 'showDebugText', displayName: 'Show Debug Text', type: 'bool', defaultValue: true, triggerInit: false },
        { paramName: 'audioSlip', displayName: 'Audio slip', type: 'float', defaultValue: 0, triggerInit: false },
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                showDebugText
            } = { ...config}
    
            const modulesRunStringsIndex = modulesRunStrings.length
            modulesRunStrings.push('.')
            const perfStartTime = window.performance.now()
            moduleRunStringsIndent++

            config.modules.forEach(moduleId => {
                const perfStartTime = window.performance.now()
    
                const eah = EntityAccessHelper.fromUuid(moduleId)

                const entityFrameTime = frameTime - eah.staticConfig.start
                if (eah.staticConfig.enabled && entityFrameTime >= 0 && entityFrameTime < eah.staticConfig.duration) {
                    if (showDebugText) debugTexts.push(eah.name)

                    const modulesRunStringsIndex = modulesRunStrings.length
                    modulesRunStrings.push(null)

                    try {
                        eah.actions.render(
                            eah.self,
                            entityFrameTime,
                            eah.combinedConfigs(entityFrameTime),
                            ctx)
                    } catch (e) {
                        console.log(`Rendering failed for: ${moduleId}, ${eah.type}:${eah.subType}, '${e}'`)
                    }

                    const perfEndTime = window.performance.now()
                    const perfDuration = perfEndTime - perfStartTime

                    modulesRunStrings[modulesRunStringsIndex] = [moduleRunStringsIndent, eah.name, perfDuration, moduleId]
                }
            })

            moduleRunStringsIndent--
            const perfEndTime = window.performance.now()
            const perfDuration = perfEndTime - perfStartTime
            modulesRunStrings[modulesRunStringsIndex] = [moduleRunStringsIndent, 'total', perfDuration, '0']
        }
    }
}
